<?php
ob_start();
include('authentication.php');
include('includes/header.php');
include('includes/navbar.php');
include('dbcon.php');

$client_id = $_GET['client_id'] ?? 0;

// Fetch existing client info
$client = mysqli_fetch_assoc(mysqli_query($conn, "SELECT * FROM tbl_client WHERE id='$client_id'"));

// Generate next GST invoice number if needed
function getNextInvoiceNumber($conn) {
    $result = mysqli_query($conn, "SELECT gst_invoice_no FROM tbl_client ORDER BY id DESC LIMIT 1");
    $row = mysqli_fetch_assoc($result);
    if($row && !empty($row['gst_invoice_no'])) {
        $lastNumber = (int) filter_var($row['gst_invoice_no'], FILTER_SANITIZE_NUMBER_INT);
        $nextNumber = $lastNumber + 1;
    } else {
        $nextNumber = 1001;
    }
    return "" . $nextNumber;
}

// Handle form submission
if (isset($_POST['update'])) {
    $cust_name = mysqli_real_escape_string($conn, $_POST['cust_name']);
    $cust_phone = mysqli_real_escape_string($conn, $_POST['cust_phone']);
    $cust_email = mysqli_real_escape_string($conn, $_POST['cust_email']);
    $cust_address = mysqli_real_escape_string($conn, $_POST['cust_address']);
    $service = mysqli_real_escape_string($conn, $_POST['service']);
    $service_date = $_POST['service_date'];
    $warranty = mysqli_real_escape_string($conn, $_POST['warranty']);
    $service_covered = mysqli_real_escape_string($conn, $_POST['service_covered']);
    $terms = mysqli_real_escape_string($conn, $_POST['service_term_condition']);
    $total_amount = $_POST['total_amount'];
    
    $apply_gst = isset($_POST['apply_gst']) ? 1 : 0;
    $billing_address = mysqli_real_escape_string($conn, $_POST['billing_address'] ?? '');
    $shipping_address = mysqli_real_escape_string($conn, $_POST['shipping_address'] ?? '');
    $gst_invoice_no = $client['gst_invoice_no']; // existing invoice

    // Assign new GST invoice number if checkbox checked and no existing invoice
    if($apply_gst && empty($gst_invoice_no)){
        $gst_invoice_no = getNextInvoiceNumber($conn);
    }

    // Calculate GST amount
    $gst_amount = $apply_gst ? $total_amount * 0.18 : 0;

    $update_query = "UPDATE tbl_client SET 
        cust_name='$cust_name',
        cust_phone='$cust_phone',
        cust_email='$cust_email',
        cust_address='$cust_address',
        service='$service',
        service_date='$service_date',
        warranty='$warranty',
        service_covered='$service_covered',
        service_term_condition='$terms',
        total_amount='$total_amount',
        apply_gst='$apply_gst',
        gst_amount='$gst_amount',
        billing_address='$billing_address',
        shipping_address='$shipping_address',
        gst_invoice_no='$gst_invoice_no'
        WHERE id='$client_id'";

    if (mysqli_query($conn, $update_query)) {
        $_SESSION['status'] = "Client Updated Successfully!";
        header("Location: view-client-detail.php?client_id=$client_id");
        exit();
    } else {
        $error = "Error: " . mysqli_error($conn);
    }
}
?>

    <div class="inquiry-container">
            <h2 class="text-center">Update Client Details</h2>
      
            <?php if(isset($error)) echo "<div class='alert alert-danger'>$error</div>"; ?>

            <form method="POST">
                <!-- Basic Client Info -->
                    <label>Name</label>
                    <input type="text" name="cust_name" value="<?= $client['cust_name']; ?>" required>
              
                    <label>Phone</label>
                    <input type="text" name="cust_phone"  value="<?= $client['cust_phone']; ?>" required>
               
            
                    <label>Email</label>
                    <input type="email" name="cust_email"  value="<?= $client['cust_email']; ?>" required>
       
           
                    <label>Address</label>
                    <textarea name="cust_address"  required><?= $client['cust_address']; ?></textarea>
        
 
                    <label>Service</label>
                    <input type="text" name="service"  value="<?= $client['service']; ?>" required>
         
          
                    <label>Service Date</label>
                    <input type="date" name="service_date"  value="<?= $client['service_date']; ?>" required>
     
            
                    <label>Warranty</label>
                    <input type="text" name="warranty"  value="<?= $client['warranty']; ?>">
            
                    <label>Service Covered</label>
                    <textarea name="service_covered" ><?= $client['service_covered']; ?></textarea>
       
      
                    <label>Terms & Conditions</label>
                    <textarea name="service_term_condition"><?= $client['service_term_condition']; ?></textarea>
              
                    <label>Total Amount</label>
                    <input type="number" step="0.01" name="total_amount"  value="<?= $client['total_amount']; ?>" required>
               
                <!-- GST Section -->
                <hr>
                <div class="form-check mb-3">
                    <input class="form-check-input" type="checkbox" id="apply_gst" name="apply_gst" value="1" <?= $client['apply_gst'] ? 'checked' : ''; ?> onclick="toggleGSTFields()">
                    <label class="form-check-label" for="apply_gst">Apply GST (18%)</label>
                </div>

                <div id="gst_fields" style="display: <?= $client['apply_gst'] ? 'block' : 'none'; ?>;">
                  
                        <label>Billing Address</label>
                        <textarea name="billing_address"><?= $client['billing_address']; ?></textarea>
           
                   
                        <label>Shipping Address</label>
                        <textarea name="shipping_address"><?= $client['shipping_address']; ?></textarea>
               
                  
                        <label>GST Invoice No</label>
                        <input type="text" name="gst_invoice_no"  value="<?= $client['gst_invoice_no'] ?: getNextInvoiceNumber($conn); ?>" readonly>
                  
                </div>
                <button type="submit" name="update" class="">Update Client</button>
            </form>
    </div>


<script>
function toggleGSTFields() {
    var gstFields = document.getElementById('gst_fields');
    gstFields.style.display = document.getElementById('apply_gst').checked ? 'block' : 'none';
}
</script>

<?php
include('includes/scripts.php');
include('includes/footer.php');
ob_end_flush();
?>
