<?php
include('authentication.php');
include('includes/header.php');
include('includes/navbar.php');
include('dbcon.php');
?>

<div class="container-fluid">

    <!-- Search Section -->
    <div class="d-flex justify-content-between mb-3">

        <!-- Search Bar -->
        <form method="GET" class="mr-2">
            <input type="text" name="search" class="form-control" placeholder="Search Client..." id="clientSearch"
                value="<?php if (isset($_GET['search'])) echo $_GET['search']; ?>">
        </form>
    </div>

    <h1 class="h3 text-gray-800 text-center mb-4">View Clients</h1>

    <!-- Client Table -->
    <div class="containers">
        <div class="card-body">
            <div class="table-responsive">

                <?php
                if (isset($_GET['search'])) {
                    $search = $_GET['search'];
                    $query = "SELECT * FROM tbl_client 
                              WHERE cust_name LIKE '%$search%' 
                              OR cust_phone LIKE '%$search%'
                              OR cust_email LIKE '%$search%'
                              ORDER BY id DESC";
                } else {
                    $query = "SELECT * FROM tbl_client ORDER BY id DESC";
                }

                $query_run = mysqli_query($conn, $query);
                ?>

                <table class="table table-bordered text-center" id="clientTable">
                    <thead class="">
                        <tr>
                            <th width="5%">Sr.No.</th>
                            <th width="12%">Name</th>
                            <th width="10%">Phone</th>
                            <th width="12%">Email</th>
                            <th width="15%">Address</th>
                            <th width="10%">Service</th>
                            <th width="10%">Service Date</th>
                            <th>Action</th>
                        </tr>
                    </thead>

                    <tbody>
                        <?php
                        $serial_no = 1;
                        if (mysqli_num_rows($query_run) > 0) {
                            while ($row = mysqli_fetch_assoc($query_run)) {
                        ?>
                                <tr>
                                    <td><?= $serial_no++; ?></td>
                                    <td><a href="view-all-employee.php?client_id=<?= $row['id']; ?>"><?= $row['cust_name']; ?></a></td>
                                    <td><?= $row['cust_phone']; ?></td>
                                    <td><?= $row['cust_email']; ?></td>
                                    <td><?= $row['cust_address']; ?></td>
                                    <td><?= $row['service']; ?></td>
                                    <td><?= $row['service_date']; ?></td>
                                    <td>
                                        <!-- View Payment / Details Button -->
                                        <button onclick="window.location.href='view-client-detail.php?client_id=<?= $row['id']; ?>'" class="actionBtn btn btn-sm btn-primary"> 
                                        View Details</button>
                                    </td>
                                </tr>
                        <?php
                            }
                        } else {
                            echo "<tr><td colspan='9'>No Clients Found</td></tr>";
                        }
                        ?>
                    </tbody>
                </table>

            </div>
        </div>
    </div>
</div>

<script src="https://code.jquery.com/jquery-3.6.0.min.js"></script>
<script>
    $(document).ready(function() {

        function loadClients(query = '') {
            $.ajax({
                url: "fetch_client.php", // PHP file that returns table rows
                method: "POST",
                data: {
                    search: query
                },
                success: function(data) {
                    $('#clientTable tbody').html(data);
                }
            });
        }

        // Load all clients initially
        loadClients();

        // Live search
        $('#clientSearch').on('keyup', function() {
            var search = $(this).val();
            loadClients(search);
        });

    });
</script>


<?php
include('includes/scripts.php');
include('includes/footer.php');
?>